unit LoadAsmImpl;

interface
  uses System.Reflection;

type
  TAssemblyLoaderHelper = class(MarshalByRefObject)
  private
    FLoadedAssembly: Assembly;
  public
    constructor Create;
    procedure Load(AssemblyName: string);
    procedure Invoke(AClassName: string; AMethodName: string);
    procedure InvokeGlobal(AMethodName: string); overload;
  end;

  TAssemblyLoader = class
  strict private
    FAppDomain: AppDomain;
    FAssemblyLoaderHelper: TAssemblyLoaderHelper;
  public
    constructor Create;
    destructor Destroy; override;
    procedure LoadAssembly(AssemblyName: string);
    procedure Invoke(AClassName, AMethodName: string);
  end;

implementation
  uses System.IO;

constructor TAssemblyLoaderHelper.Create;
begin
  inherited Create;
  FLoadedAssembly := nil;
end;

procedure TAssemblyLoaderHelper.Invoke(AClassName, AMethodName: string);
var
  AClass: &Type;
begin
  AClass := FLoadedAssembly.GetType(AClassName);
  if Assigned(AClass) then
    AClass.InvokeMember(AMethodName, BindingFlags.InvokeMethod, nil, nil, []);
end;

procedure TAssemblyLoaderHelper.InvokeGlobal(AMethodName: string);
var
 ATypes: array of &Type;
 Assm: Assembly;
 I: Integer;
begin
 Assm := Assembly.Load('testpkg');
 ATypes := Assm.GetExportedTypes;
// Modules := Assm.GetModules(False);
 for I := Low(ATypes) to High(ATypes) do
  if ATypes[I].ToString.EndsWith('Unit') then
end;

procedure TAssemblyLoaderHelper.Load(AssemblyName: string);
begin
  FLoadedAssembly := Assembly.Load(AssemblyName);
end;

{ TAssemblyLoader }

constructor TAssemblyLoader.Create;
begin
  inherited Create;
end;

destructor TAssemblyLoader.Destroy;
begin
  FAssemblyLoaderHelper := nil;
  if Assigned(FAppDomain) then
    AppDomain.Unload(FAppDomain);
  FAppDomain := nil;
  inherited;
end;

/// Invokes a method from the specified class in the assembly
procedure TAssemblyLoader.Invoke(AClassName, AMethodName: string);
begin
  FAssemblyLoaderHelper.Invoke(AClassName, AMethodName);
end;

procedure TAssemblyLoader.LoadAssembly;
var
  fi: FileInfo;
  setup: AppDomainSetup;
  BaseDir, AsmName: string;
begin
  fi := FileInfo.Create(AssemblyName);
  setup := AppDomainSetup.Create;
  BaseDir := fi.DirectoryName;
  setup.ApplicationBase := BaseDir;
  setup.PrivateBinPath := '.';
  setup.ApplicationName := 'Loader';
  setup.ShadowCopyFiles := 'true';
  setup.ShadowCopyDirectories := setup.ApplicationBase+';'+fi.DirectoryName;

  FAppDomain := AppDomain.CreateDomain('Loading Domain', nil, setup);

  FAssemblyLoaderHelper := TAssemblyLoaderHelper
   (FAppDomain.CreateInstanceFromAndUnwrap(Assembly.GetExecutingAssembly.Location,
    'LoadAsmImpl.TAssemblyLoaderHelper'));

  AsmName := fi.Name.Replace(fi.Extension, '');
  FAssemblyLoaderHelper.Load(AsmName);
end;

end.
